% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sim_copula.R
\name{data_sim_copula}
\alias{data_sim_copula}
\title{Simulate bivariate time-to-event times based on specific copula and marginal distributions}
\usage{
data_sim_copula(n, copula, eta, dist, baseline, var_list, COV_beta, x1, x2)
}
\arguments{
\item{n}{sample size}

\item{copula}{types of copula, including "Clayton", "Gumbel", "Frank", "AMH" and "Joe"}

\item{eta}{copula parameter}

\item{dist}{marginal distributions, including "Weibull", "Gompertz" and "Loglogistic"}

\item{baseline}{marginal distribution parameters. For weibull and loglogistic, it shall be lambda (scale) and k (shape); for gompertz, it shall be a (shape) and b (rate)}

\item{var_list}{a vector of covariate names; assume same covariate names for two margins}

\item{COV_beta}{a vector of regression coefficients corresponding to var_list; assume same COV_beta between two margins}

\item{x1}{a data frame of covariates for margin 1; it shall have n rows, with columns corresponding to the var_list}

\item{x2}{a data frame of covariates for margin 2}
}
\value{
a data frame of bivariate time-to-event data with covariate
}
\description{
This function (data_sim_copula) is to generate a sample of subjects with two correlated event times based on specific copula and marginal models
}
\examples{
library(CopulaCenR)
set.seed(1)
dat <- data_sim_copula(n = 500, copula = "Clayton", eta = 3,
                       dist = "Weibull", baseline = c(0.1,2),
                       var_list = c("var1", "var2"),
                       COV_beta = c(0.1, 0.1),
                       x1 = cbind(rnorm(500, 6, 2),
                                  rbinom(500, 1, 0.5)),
                       x2 =  cbind(rnorm(500, 6, 2),
                                   rbinom(500, 1, 0.5)))
plot(x = dat$time[dat$ind == 1], y = dat$time[dat$ind == 2],
     xlab = expression(t[1]), ylab = expression(t[2]),
     cex.axis = 1, cex.lab = 1.3)
}
