% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_product_metadata.r
\name{cms_product_metadata}
\alias{cms_product_metadata}
\title{Obtain meta data for a specific Copernicus marine product}
\usage{
cms_product_metadata(product, type = c("list", "xml"))
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{cms_products_list}}.}

\item{type}{A \code{character} string indicating how the data should be returned. Should be one of
\code{"list"} or \code{"xml"}.}
}
\value{
Returns a named \code{list} (when \code{type = "list"}) with info about the requested \code{product}.
Returns the same info as \code{xml_document} (see \code{\link[xml2:xml_new_document]{xml2::xml_new_document()}}) when \code{type = "xml"}.
Returns \code{NULL} when contacting Copernicus fails.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Collect meta information, such as vocabularies used,
for specific Copernicus marine products
}
\examples{
\donttest{
cms_product_metadata("GLOBAL_ANALYSISFORECAST_PHY_001_024")
}
}
\seealso{
Other product-functions: 
\code{\link{cms_cite_product}()},
\code{\link{cms_product_details}()},
\code{\link{cms_product_services}()},
\code{\link{cms_products_list}()},
\code{\link{copernicus_cite_product}()},
\code{\link{copernicus_product_details}()},
\code{\link{copernicus_product_metadata}()},
\code{\link{copernicus_products_list}()}
}
\author{
Pepijn de Vries
}
\concept{product-functions}
