% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python.R
\name{cds_python_to_r}
\alias{cds_python_to_r}
\title{Translate Python Climate Data Store request to R request}
\usage{
cds_python_to_r(text, ...)
}
\arguments{
\item{text}{A \code{character} string containing the Python code copied
from a dataset download website \url{https://cds.climate.copernicus.eu/datasets}.
When missing, the function will use any text on the system clipboard.
This means that you can copy the API request code from the website to the
clipboard, then call this function without arguments.}

\item{...}{Ignored}
}
\value{
A named \code{list} that can be used as input for the functions
\code{cds_submit_job()} and \code{cds_estimate_costs()}
}
\description{
When looking for a dataset on \url{https://cds.climate.copernicus.eu/datasets},
you have the option to copy the API request code to the clipboard. However,
this is Python code and cannot be used directly in this package.
Use this function to translate the code to a request that can be handled by
the package. For more details see \code{vignette("translate")}
}
\examples{
python_code <-
"import cdsapi
dataset = \"reanalysis-era5-land\"
request = {
  \"variable\": [\"2m_dewpoint_temperature\"],
  \"year\": \"2025\",
  \"month\": \"01\",
  \"day\": [\"01\"],
  \"time\": [
    \"00:00\", \"01:00\", \"02:00\",
    \"03:00\", \"04:00\", \"05:00\",
    \"06:00\", \"07:00\", \"08:00\",
    \"09:00\", \"10:00\", \"11:00\",
    \"12:00\", \"13:00\", \"14:00\",
    \"15:00\", \"16:00\", \"17:00\",
    \"18:00\", \"19:00\", \"20:00\",
    \"21:00\", \"22:00\", \"23:00\"
  ],
  \"data_format\": \"netcdf\",
  \"download_format\": \"unarchived\"
}

client = cdsapi.Client()
client.retrieve(dataset, request).download()
"

cds_python_to_r(python_code)
}
