% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EHypQuInt.R
\name{EHypQuInt}
\alias{EHypQuInt}
\title{Interval of alpha values for which X is a specified q'th quantile}
\usage{
EHypQuInt(x, marg, q, scal = log(2 * marg[3]^2))
}
\arguments{
\item{x}{integer co-occurrence count that should properly fall within the closed interval [max(0,mA+mB-N), min(mA,mB)]}

\item{marg}{a 3-entry integer vector (mA,mB,N) consisting of the first row and column totals and the table total for a 2x2 contingency table}

\item{q}{a quantile falling strictly between 0 and 1}

\item{scal}{an integer parameter (default 2*N^2, capped at 10 within the function) that should be 2 or greater}
}
\value{
This function returns the vector (a1, a2) defined above, the endpoints of the set of alpha values for which x is a q'th quantile of the Extended Hypergeometric distribution.
}
\description{
This function outputs the largest interval of log-odds parameter values alpha for which
the Extended Hypergeometric distribution function at x is >= q and the complementary distribution function 1 - F(x-) is >= 1-q.
}
\details{
This function outputs the endpoints  a1, a2 defined by

F(x, a1) = q      and    F(x-1, a2) = q

where  F(z, a) = F(z, mA,mB,N, exp(a)) is the extended Hypergeometric distribution function.

The interval of alpha values with these endpoints a1, a2 is viewed as the set of alpha values "compatible" with x being a q'th quantile for the Extended Hypergeometric.
}
\examples{
EHypQuInt(30,c(50,80,120), 0.95)
EHypQuInt(30,c(50,80,120), 0.05)

EHypQuInt(30,c(50,80,120), 0.5)
AlphInts(30,c(50,80,120), lev=0.9)$MedianIntrvl
}
\author{
Eric Slud
}
