% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_groups.R
\name{detect_groups}
\alias{detect_groups}
\title{detect_groups}
\usage{
detect_groups(
  x,
  time_window = 10,
  min_participation = 2,
  remove_loops = TRUE,
  ...
)
}
\arguments{
\item{x}{a data.table with the columns: \code{object_id} (uniquely identifies
coordinated content), \code{account_id} (unique ids for accounts), \code{content_id}
(id of account generated content), \code{timestamp_share} (integer). See also
\link{reshape_tweets} and \link{prep_data}.}

\item{time_window}{the number of seconds within which shared contents
are to be considered as coordinated (default to 10 seconds).}

\item{min_participation}{The minimum number of actions within a specified timeframe
required for a account to be included in subsequent analysis (default set at 2).
This criterion in network analysis corresponds with the concept of degree.
It is important to distinguish this from the frequency of repeated interactions
an account has with another specific account, as represented by edge weight.
The edge weight parameter is utilized in the \code{generate_network} function as a
concluding step in identifying coordinated behavior.}

\item{remove_loops}{Should loops (shares of the same objects made by the same account
within the time window) be removed? (default to TRUE).}

\item{...}{keyword arguments for backwards compatibility.}
}
\value{
a data.table with ids of coordinated contents. Columns:
\code{object_id}, \code{account_id}, \code{account_id_y}, \code{content_id}, \code{content_id_y},
\code{timedelta}. The \code{account_id} and \code{content_id} represent the "older"
data points, \code{account_id_y} and \code{content_id_y} represent the "newer"
data points. For example, account A retweets from account B, then account A's
content is newer (i.e., \code{account_id_y}).
}
\description{
Function to perform the initial stage in detecting coordinated behavior.
It identifies pairs of accounts that share the same objects in a time_window.
See details.
}
\details{
This function achieves the initial stage in detecting coordinated behavior
by identifying accounts who share identical objects within the same temporal window, and is
preliminary to the network analysis conducted using the \link{generate_coordinated_network} function.
\code{detect_groups} groups the data by \code{object_id} (uniquely identifies
coordinated content) and calculates the time differences between all
\code{content_id} (ids of account generated contents) within their groups.
It then filters out all \code{content_id} that are higher than the \code{time_window}
(in seconds). It returns a \code{data.table} with all IDs of coordinated
contents. The \code{object_id} can be for example: hashtags, IDs of tweets being
retweeted, or URLs being shared. For twitter data, best use \link{reshape_tweets}.
}
