% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_coordinated_groups.R
\name{detect_similar_text}
\alias{detect_similar_text}
\title{detect_similar_text}
\usage{
detect_similar_text(
  x,
  min_repetition = 2,
  time_window = 10,
  min_similarity = 0.8,
  similarity_function = textreuse::jaccard_similarity,
  tokenizer = textreuse::tokenize_ngrams,
  minhash_seed = NULL,
  minhash_n = 200
)
}
\arguments{
\item{x}{A data.table with the following columns:
\itemize{
\item content_id: The ID of the content (e.g. a tweet ID)
\item object_id: The text of the social media post
\item id_user: The ID of the user who shared the content
\item timestamp_share: The timestamp when the content was shared
}}

\item{min_repetition}{the minimum number of repeated coordinated
actions a user has to perform (defaults to 2 times)}

\item{time_window}{The maximum time difference between two posts in order
for them to be considered coordinated cotweets (defaults to 10 seconds).}

\item{min_similarity}{The minimum similarity score between two posts in order
for them to be considered coordinated cotweets (defaults to 0.8).}

\item{similarity_function}{The function that is used to calculate the similarity
between two tweets. The default function is Jaccard Similarity (see: \link[textreuse]{jaccard_similarity}).}

\item{tokenizer}{The function that is used to tokenize the text of the tweets.
The default function is the \link[textreuse]{tokenize_ngrams} function.}

\item{minhash_seed}{The seed that is used to generate the minhash signatures.
If NULL, a random seed will be used.}

\item{minhash_n}{The number of minhash signatures that are used (see \code{textreuse} package for details).}
}
\value{
A data.table with the following columns:
\itemize{
\item content_id: The ID of the first post
\item content_id_y: The ID of the second post
\item id_user: The ID of the user who shared the first post
\item id_user_y: The ID of the user who shared the second post
\item timestamp_share: The timestamp when the first post was shared
\item timestamp_share_y: The timestamp when the second post was shared
\item similarity_score: The similarity score between the two posts
\item time_delta: The time difference between the two posts
}
}
\description{
This function detects coordinated cotweets, i.e. pairs of social media posts that
are similar in terms of their text and were posted within a short time window.
}
\details{
Uses the \href{https://cran.r-project.org/package=textreuse}{textreuse} package
to compare each post with each other and determine their text similarity. Use the
\code{\link[=reshape_tweets]{reshape_tweets()}} function with \code{intent = "cotweet"} parameter to prepare your data.
}
