% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateMod.R
\name{estimateMod}
\alias{estimateMod}
\title{Log-t test for convergence}
\usage{
estimateMod(H, time_trim = 1/3, HACmethod = c("FQSB", "AQSB"))
}
\arguments{
\item{H}{vector of H values}

\item{time_trim}{a numeric value between 0 and 1, representing the portion of
time periods to trim when running \emph{log t} regression model.
Phillips and Sul (2007, 2009) suggest to discard the first third of the period.}

\item{HACmethod}{string indicating whether a Fixed Quadratic Spectral Bandwidth (\code{HACmethod="FQSB"}) or
an Adaptive Quadratic Spectral Bandwidth (\code{HACmethod="AQSB"}) should be used for the truncation
of the Quadratic Spectral kernel in estimating the \emph{log t} regression model
with heteroskedasticity and autocorrelation consistent standard errors.
The default method is "FQSB".}
}
\value{
A named vector containing information about the model used to run the t-test
on the units in the club: beta coefficient, standard deviation, t-statistics and p-value.
}
\description{
Estimates the \emph{log-t} regression model proposed by Phillips and Sul (2007, 2009)
in order to investigate the presence of convergence by adopting the
Andrews estimator of long-run variance (fixed or adaptive bandwidth of the kernel).
}
\details{
The following linear model is estimated:
\deqn{\log\frac{H_1}{H_t} - 2\log(\log{t}) = \alpha + \beta \log{t} + u_t}{
           log[H(1)/H(t)] - 2log[log(t)] = \alpha + \beta log(t) + u(t)  }

Heteroskedasticity and autocorrelation consistent (HAC) standard errors are used with
Quadratic Spectral kernel (Andrews, 1991), If  \code{HACmethod}="FQSB",
a fixed bandwidth parameter is applied, while with \code{HACmethod}="AQSB" an
adaptive bandwidth parameter is employed.
}
\references{
Phillips, P. C.; Sul, D., 2007.
Transition modeling and econometric convergence tests. Econometrica 75 (6), 1771-1855.

Phillips, P. C.; Sul, D., 2009. Economic transition and growth.
Journal of Applied Econometrics 24 (7), 1153-1185.

Andrews, D. W., 1991. Heteroskedasticity and autocorrelation consistent covariance matrix estimation.
Econometrica: Journal of the Econometric Society, 817-858.
}
