% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_grid1.R
\name{cf_grid1}
\alias{cf_grid1}
\title{Makes filled contour plot without sidebar, essentially filled.contour function.
A sidebar can be added by setting bar to TRUE. However, this will cause any other
plot functions used afterwards, such as points, to not put points at the correct spot.}
\usage{
cf_grid1(x = seq(0, 1, length.out = nrow(z)), y = seq(0, 1, length.out =
  ncol(z)), z, xlim = range(x, finite = TRUE), ylim = range(y, finite =
  TRUE), zlim = range(z, finite = TRUE), levels = pretty(zlim, nlevels),
  nlevels = 20, color.palette = cm.colors,
  col = color.palette(length(levels) - 1), plot.title, plot.axes, key.title,
  key.axes, asp = NA, xaxs = "i", yaxs = "i", las = 1, axes = TRUE,
  frame.plot = axes, bar = F, pts = NULL, reset.par = T, ...)
}
\arguments{
\item{x}{x values, must form grid with y}

\item{y}{y values, must form grid with x}

\item{z}{z values at grid locations}

\item{xlim}{x limits for the plot.}

\item{ylim}{y limits for the plot.}

\item{zlim}{z limits for the plot.}

\item{levels}{a set of levels which are used to partition the range of z. Must be strictly increasing (and finite). Areas with z values between consecutive levels are painted with the same color.}

\item{nlevels}{if levels is not specified, the range of z, values is divided into approximately this many levels.}

\item{color.palette}{a color palette function to be used to assign colors in the plot.}

\item{col}{an explicit set of colors to be used in the plot. This argument overrides any palette function specification. There should be one less color than levels}

\item{plot.title}{statements which add titles to the main plot.}

\item{plot.axes}{statements which draw axes (and a box) on the main plot. This overrides the default axes.}

\item{key.title}{statements which add titles for the plot key.}

\item{key.axes}{statements which draw axes on the plot key. This overrides the default axis.}

\item{asp}{the y/x aspect ratio, see plot.window.}

\item{xaxs}{the x axis style. The default is to use internal labeling.}

\item{yaxs}{the y axis style. The default is to use internal labeling.}

\item{las}{the style of labeling to be used. The default is to use horizontal labeling.}

\item{axes}{logical indicating if axes should be drawn, as in plot.default.}

\item{frame.plot}{logical indicating if a box should be drawn, as in plot.default.}

\item{bar}{Should a bar showing the output range and colors be shown on the right?}

\item{pts}{Points to plot on top of contour}

\item{reset.par}{Should the graphical parameters be reset before exiting? Usually should be.}

\item{...}{additional graphical parameters, currently only passed to title().}
}
\description{
Makes filled contour plot without sidebar, essentially filled.contour function.
A sidebar can be added by setting bar to TRUE. However, this will cause any other
plot functions used afterwards, such as points, to not put points at the correct spot.
}
\examples{
x <- y <- seq(-4*pi, 4*pi, len = 27)
r <- sqrt(outer(x^2, y^2, "+"))
cf_grid1(cos(r^2)*exp(-r/(2*pi)))
}
\references{
[1] filled.contour R function, copied function but removed part for sidebar

[2] http://stackoverflow.com/questions/16774928/removing-part-of-a-graphic-in-r, answer by P Lapointe
}
