% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_generation_functions.R
\name{gaussian_mixture_clusters}
\alias{gaussian_mixture_clusters}
\title{Generate clusters of data points from Gaussian-mixture-model distributions with randomly generated parameters}
\usage{
gaussian_mixture_clusters(
  n = c(50, 50),
  dim = 2,
  sd.max = 0.1,
  sd.noise = 0.01,
  r.range = c(0.1, 1),
  mixture.range = c(1, 4),
  mixture.sep = 0.5
)
}
\arguments{
\item{n}{vector of number of data points in each cluster
The length of \code{n} should be equal to the number of clusters.}

\item{dim}{number of dimensions}

\item{sd.max}{maximum standard deviation of clusters}

\item{sd.noise}{standard deviation of the added noise}

\item{r.range}{the range (min, max) of distance of cluster centers from the origin}

\item{mixture.range}{range (min, max) of the number of Gaussian-mixtures.}

\item{mixture.sep}{scaler indicating the separability between the mixtures.}
}
\value{
a list of data points (X) and cluster labels (class)
}
\description{
Generate clusters of data points from Gaussian-mixture-model distributions with randomly generated parameters
}
\examples{
data = gaussian_mixture_clusters()
X = data$X
y = data$class

}
