% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{CT_Hyphotesis_Test}
\alias{CT_Hyphotesis_Test}
\title{Hypothesis test for testing whether samples originate from the same distribution}
\usage{
CT_Hyphotesis_Test(Sample_List, Num_Sim = 10000, H = 0)
}
\arguments{
\item{Sample_List}{List of numeric data vectors with the elements of each sample.}

\item{Num_Sim}{The number of used simulations. The default is 10000.}

\item{H}{0 by default. If set to 1, the Kruskal-Wallis Test is also performed.}
}
\value{
The function returns a list with the following elements:
\enumerate{
\item{ \code{results}: Table with the statistics and the signification levels.}
 \item{ \code{C_p-value}: Concordance test signification level. }
 \item{ \code{H_p-value}: Kruskal Wallis test signification level (only if H = 1). }
}
}
\description{
This function performs the hypothesis test for testing whether samples originate from the same distribution.
}
\examples{
## Hollander & Wolfe (1973), 116.
## Mucociliary efficiency from the rate of removal of dust in normal
##  subjects, subjects with obstructive airway disease, and subjects
##  with asbestosis.
x <- c(2.9, 3.0, 2.5, 2.6, 3.2) # normal subjects
y <- c(3.8, 2.7, 4.0, 2.4)      # with obstructive airway disease
z <- c(2.8, 3.4, 3.7, 2.2, 2.0) # with asbestosis
Sample_List <- list(x, y, z)
CT_Hyphotesis_Test(Sample_List, Num_Sim = 1000, H = 1)


## Example
A <- c(12,13,15,20,23,28,30,32,40,48)
B <- c(29,31,49,52,54)
C <- c(24,26,44)
Sample_List <- list(A, B, C)
CT_Hyphotesis_Test(Sample_List, Num_Sim = 1000, H = 1)

## Example with ties
A <- c(12,13,15,20,24,29,30,32,40,49)
B <- c(29,31,49,52,54)
C <- c(24,26,44)
Sample_List <- list(A, B, C)
CT_Hyphotesis_Test(Sample_List, Num_Sim = 1000, H = 1)
}
