% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImpactMG.R
\name{ImpactMG}
\alias{ImpactMG}
\title{Impacts  under droughts and hot extremes}
\usage{
ImpactMG(PRC,TEM,Y,u0)
}
\arguments{
\item{PRC}{Precipitation or drought indicator corresponding to the impact variable Y}

\item{TEM}{Temperature or heat indicator  corresponding to the impact variable Y}

\item{Y}{Impact variable (e.g., Crop yield)}

\item{u0}{Initial condition of (PRC,TEM)}
}
\value{
A vector of conditional mean and variance evaluated at u0
}
\description{
Use the meta-Gaussian model to construct  conditional distributions of
the impact variable (Y)  given drought and hot conditions P(Y|PRC,TEM).
}
\examples{
PRC=matrix(rnorm(60,0,1),ncol=1)
TEM=matrix(rnorm(60,0,1),ncol=1)
Y=matrix(rnorm(60,0,1),ncol=1)
u0=c(-1.2,1.2) # Speficify the compound dry-hot condition
ImpactMG(PRC,TEM,Y,u0)
}
\references{
Feng, S. et al. (2019). Probabilistic evaluation of the impact of compound dry-hot events on global maize yields. Sci. Total. Environ., 689: 1228-1234.

Hao, Z.  et al. (2018). A multivariate approach for statistical assessments of compound extremes. J. Hydrol., 565: 87-94.
}
