% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectsize_cbe.R
\name{effectsize_cbe}
\alias{effectsize_cbe}
\title{Effect for composite binary endpoints}
\usage{
effectsize_cbe(
  p0_e1,
  p0_e2,
  eff_e1,
  effm_e1,
  eff_e2,
  effm_e2,
  effm_ce = "diff",
  rho
)
}
\arguments{
\item{p0_e1}{numeric parameter, probability of occurrence E1 in the control group}

\item{p0_e2}{numeric parameter, probability of occurrence E2 in the control group}

\item{eff_e1}{numeric parameter, anticipated effect for the composite component E1}

\item{effm_e1}{Effect measure used for the event E1  (effm_e1 = "diff" for difference of proportions, effm_e1 = "rr" for risk ratio, effm_e1 = "or" for odds ratio)}

\item{eff_e2}{numeric parameter, anticipated effect for the composite component E2}

\item{effm_e2}{Effect measure used for the event E2  (effm_e2 = "diff" for difference of proportions, effm_e2 = "rr" for risk ratio, effm_e2 = "or" for odds ratio)}

\item{effm_ce}{Effect measure used for the composite endpoint (effm_ce = "diff" for difference of proportions, effm_ce = "rr" for risk ratio, effm_ce = "or" for odds ratio)}

\item{rho}{numeric parameter, Pearson's correlation between the two events E1 and E2}
}
\value{
Returns the effect for the composite binary endpoint and the effects for the composite components.
}
\description{
This function calculates different effect measures for binary composite outcomes. 
The composite endpoint is assumed to be a binary endpoint formed by a combination of two events (E1 and E2).
The effect size is calculated on the basis of anticipated information on the composite components and the correlation between them. The function allows to compute the effect size in terms of the risk difference, risk ratio and odds ratio.
}
\details{
The input parameters stand for the probability of the composite components and Pearson's correlation between the two components.
Note that Pearson's correlation takes values between two bounds that depend on the probabilities p0_e1 and p0_e2.
To calculate the correlation bounds you can use the R functions lower_corr and upper_corr, available in this package.
}
\references{
Bofill Roig, M., & Gómez Melis, G. (2019). A new approach for sizing trials with composite binary endpoints using anticipated marginal values and accounting for the correlation between components. Statistics in Medicine, 38(11), 1935-1956. https://doi.org/10.1002/sim.8092
}
