% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cox_Regression.R
\name{RunCoxRegression_Guesses_CPP}
\alias{RunCoxRegression_Guesses_CPP}
\title{Performs basic Cox Proportional Hazards regression, Generates multiple starting guesses on c++ side}
\usage{
RunCoxRegression_Guesses_CPP(
  df,
  time1 = "start",
  time2 = "end",
  event0 = "event",
  names = c("CONST"),
  term_n = c(0),
  tform = "loglin",
  keep_constant = c(0),
  a_n = c(0),
  modelform = "M",
  fir = 0,
  der_iden = 0,
  control = list(),
  guesses_control = list(),
  strat_col = "null",
  model_control = list(),
  cens_weight = "null"
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{event0}{column used for event status}

\item{names}{columns for elements of the model, used to identify data columns}

\item{term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters. May be either a list of vectors or a single vector.}

\item{modelform}{string specifying the model type: M, ME, A, PA, PAE, GMIX, GMIX-R, GMIX-E}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter, should be smaller than total number of parameters. indexed starting at 0}

\item{control}{list of parameters controlling the convergence, see Def_Control() for options or vignette("Control_Options")}

\item{guesses_control}{list of parameters to control how the guessing works, see Def_Control_Guess() for options or vignette("Control_Options")}

\item{strat_col}{column to stratify by if needed}

\item{model_control}{controls which alternative model options are used, see Def_model_control() for options and vignette("Control_Options") for further details}

\item{cens_weight}{column containing the row weights}
}
\value{
returns a list of the final results
}
\description{
\code{RunCoxRegression_Guesses_CPP} uses user provided data, time/event columns, vectors specifying the model, and options to control the convergence and starting positions. Has additional options to starting with several initial guesses
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette
df <- data.table::data.table(
  "UserID" = c(112, 114, 213, 214, 115, 116, 117),
  "Starting_Age" = c(18, 20, 18, 19, 21, 20, 18),
  "Ending_Age" = c(30, 45, 57, 47, 36, 60, 55),
  "Cancer_Status" = c(0, 0, 1, 0, 1, 0, 0),
  "a" = c(0, 1, 1, 0, 1, 0, 1),
  "b" = c(1, 1.1, 2.1, 2, 0.1, 1, 0.2),
  "c" = c(10, 11, 10, 11, 12, 9, 11),
  "d" = c(0, 0, 0, 1, 1, 1, 1),
  "e" = c(0, 0, 1, 0, 0, 0, 1)
)
# For the interval case
time1 <- "Starting_Age"
time2 <- "Ending_Age"
event <- "Cancer_Status"
names <- c("a", "b", "c", "d")
a_n <- c(1.1, -0.1, 0.2, 0.5) # used to test at a specific point
term_n <- c(0, 1, 1, 2)
tform <- c("loglin", "lin", "lin", "plin")
modelform <- "M"
fir <- 0
keep_constant <- c(0, 0, 0, 0)
der_iden <- 0
control <- list(
  "ncores" = 2, "lr" = 0.75, "maxiter" = 5,
  "halfmax" = 5, "epsilon" = 1e-3,
  "deriv_epsilon" = 1e-3, "abs_max" = 1.0, "change_all" = TRUE,
  "dose_abs_max" = 100.0, "verbose" = FALSE, "ties" = "breslow",
  "double_step" = 1
)
guesses_control <- list(
  "maxiter" = 10, "guesses" = 10,
  "lin_min" = 0.001, "lin_max" = 1,
  "loglin_min" = -1, "loglin_max" = 1,
  "lin_method" = "uniform",
  "loglin_method" = "uniform", strata = FALSE
)
strat_col <- "e"
options(warn = -1)
e <- RunCoxRegression_Guesses_CPP(
  df, time1, time2, event, names, term_n,
  tform, keep_constant, a_n, modelform, fir,
  der_iden, control, guesses_control, strat_col
)
}
\seealso{
Other Cox Wrapper Functions: 
\code{\link{CoxCurveSolver}()},
\code{\link{RunCoxNull}()},
\code{\link{RunCoxRegression}()},
\code{\link{RunCoxRegression_Basic}()},
\code{\link{RunCoxRegression_CR}()},
\code{\link{RunCoxRegression_Omnibus}()},
\code{\link{RunCoxRegression_Omnibus_Multidose}()},
\code{\link{RunCoxRegression_Single}()},
\code{\link{RunCoxRegression_Strata}()},
\code{\link{RunCoxRegression_Tier_Guesses}()}
}
\concept{Cox Wrapper Functions}
