% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Make_subterms}
\alias{Make_subterms}
\title{Utility function to calculate the term and subterm values
\code{Make_subterms} Called to update term matrices, Uses lists of term numbers and types to apply formulas}
\usage{
Make_subterms(
  totalnum,
  Term_n,
  tform,
  dfc,
  fir,
  T0,
  Td0,
  Tdd0,
  Dose,
  nonDose,
  TTerm,
  nonDose_LIN,
  nonDose_PLIN,
  nonDose_LOGLIN,
  beta_0,
  df0,
  dint,
  dslp,
  nthreads,
  debugging,
  KeepConstant
)
}
\arguments{
\item{totalnum}{total number of parameters}

\item{Term_n}{Term numbers}

\item{tform}{subterm types}

\item{dfc}{vector matching subterm number to matrix column}

\item{fir}{st term number}

\item{T0}{Term value for each subterm}

\item{Td0}{Term by subterm derivative matrix}

\item{Tdd0}{Term by subterm second derivative matrix}

\item{Dose}{term matrix}

\item{nonDose}{term matrix}

\item{TTerm}{Total term matrix}

\item{nonDose_LIN}{Linear term matrix}

\item{nonDose_PLIN}{Product linear term matrix}

\item{nonDose_LOGLIN}{Loglinear term matrix}

\item{beta_0}{parameter estimates}

\item{df0}{matrix of covariate values}

\item{dint}{value used for threshold derivative finite step}

\item{dslp}{value used for slope derivative finite step}

\item{nthreads}{number of threads available}

\item{debugging}{additional boolean for verbosity in testing}

\item{KeepConstant}{binary vector to identify constant parameters}
}
\value{
Updates matrices in place: subterm matrices, Term matrices
}
\description{
Utility function to calculate the term and subterm values
\code{Make_subterms} Called to update term matrices, Uses lists of term numbers and types to apply formulas
}
