% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotTypes.R
\name{CoxRisk}
\alias{CoxRisk}
\title{calculates and plots relative risk
\code{CoxRisk} uses user provided data, columns, and identifier to create plots of risk by covariate value for each column}
\usage{
CoxRisk(
  verbose,
  df,
  event0,
  time1,
  time2,
  names,
  Term_n,
  tform,
  a_n,
  fir,
  der_iden,
  modelform,
  control,
  keep_constant,
  Plot_Type,
  b,
  er,
  model_control = list()
)
}
\arguments{
\item{verbose}{boolean to control if additional information is printed to the console}

\item{df}{a data.table containing the columns of interest}

\item{event0}{column used for event status}

\item{time1}{column used for time period starts}

\item{time2}{column used for time period end}

\item{names}{columns for elements of the model, used to identify data columns}

\item{Term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{a_n}{list of initial parameter values, used to determine number of parameters}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter}

\item{modelform}{string specifying the model type}

\item{control}{list of parameters controlling the convergence}

\item{keep_constant}{binary values to denote which parameters to change}

\item{Plot_Type}{list of parameters controlling the plot options}

\item{b}{optimum parameter values used}

\item{er}{standard deviation for the parameters}

\item{model_control}{controls which alternative model options are used}
}
\value{
saves the plots in the current directory and returns a string that it passed
}
\description{
calculates and plots relative risk
\code{CoxRisk} uses user provided data, columns, and identifier to create plots of risk by covariate value for each column
}
