% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Calc_LogLik_STRATA_SINGLE}
\alias{Calc_LogLik_STRATA_SINGLE}
\title{Utility function to calculate just Cox Log-Likelihood with STRATA
\code{Calc_LogLik_STRATA_SINGLE} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time and strata}
\usage{
Calc_LogLik_STRATA_SINGLE(
  nthreads,
  RiskFail,
  RiskGroup,
  totalnum,
  ntime,
  R,
  Rls1,
  Lls1,
  Ll,
  debugging,
  ties_method,
  STRATA_vals,
  KeepConstant
)
}
\arguments{
\item{nthreads}{number of threads available}

\item{RiskFail}{matrix of indexes for event rows in each risk group}

\item{RiskGroup}{list of string indices for every risk group}

\item{totalnum}{total number of parameters}

\item{ntime}{number of risk groups}

\item{R}{risk vector}

\item{Rls1}{First Risk sum storage}

\item{Lls1}{Second Risk sum storage}

\item{Ll}{Log-likelihood vector}

\item{debugging}{additional boolean for verbosity in testing}

\item{ties_method}{Ties method}

\item{STRATA_vals}{vector of strata identifier values}

\item{KeepConstant}{binary vector to identify constant parameters}
}
\value{
Updates matrices in place: Log-likelihood vectors/matrix
}
\description{
Utility function to calculate just Cox Log-Likelihood with STRATA
\code{Calc_LogLik_STRATA_SINGLE} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time and strata
}
