% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Calc_LogLik_STRATA}
\alias{Calc_LogLik_STRATA}
\title{Utility function to calculate Cox Log-Likelihood and derivatives with STRATA
\code{Calc_LogLik_STRATA} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time}
\usage{
Calc_LogLik_STRATA(
  nthreads,
  RiskFail,
  RiskGroup,
  totalnum,
  ntime,
  R,
  Rd,
  Rdd,
  RdR,
  RddR,
  Rls1,
  Rls2,
  Rls3,
  Lls1,
  Lls2,
  Lls3,
  Ll,
  Lld,
  Lldd,
  debugging,
  ties_method,
  STRATA_vals,
  KeepConstant
)
}
\arguments{
\item{nthreads}{number of threads available}

\item{RiskFail}{matrix of indexes for event rows in each risk group}

\item{RiskGroup}{list of string indices for every risk group}

\item{totalnum}{total number of parameters}

\item{ntime}{number of risk groups}

\item{R}{risk vector}

\item{Rd}{Risk first derivative matrix}

\item{Rdd}{Risk second derivative matrix}

\item{RdR}{Risk to first derivative ratio matrix}

\item{RddR}{Risk to second derivative ratio matrix}

\item{Rls1}{First Risk sum storage}

\item{Rls2}{First Risk sum derivative storage}

\item{Rls3}{First Risk sum second derivative storage}

\item{Lls1}{Second Risk sum storage}

\item{Lls2}{Second Risk sum derivative storage}

\item{Lls3}{Second Risk sum second derivative storage}

\item{Ll}{Log-likelihood vector}

\item{Lld}{Log-likelihood first derivative matrix}

\item{Lldd}{Log-likelihood second derivative matrix}

\item{debugging}{additional boolean for verbosity in testing}

\item{ties_method}{Ties method}

\item{STRATA_vals}{vector of strata identifier values}

\item{KeepConstant}{binary vector to identify constant parameters}
}
\value{
Updates matrices in place: Log-likelihood vectors/matrix
}
\description{
Utility function to calculate Cox Log-Likelihood and derivatives with STRATA
\code{Calc_LogLik_STRATA} Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
}
