% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Calc_LogLik_Basic_Single}
\alias{Calc_LogLik_Basic_Single}
\title{Utility function to calculate Cox Log-Likelihood, basic model
\code{Calc_LogLik_Basic_Single} Basic model, Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time}
\usage{
Calc_LogLik_Basic_Single(
  nthreads,
  RiskFail,
  RiskGroup,
  totalnum,
  ntime,
  R,
  Rls1,
  Lls1,
  Ll,
  debugging,
  ties_method,
  KeepConstant
)
}
\arguments{
\item{nthreads}{number of threads available}

\item{RiskFail}{matrix of indexes for event rows in each risk group}

\item{RiskGroup}{list of string indices for every risk group}

\item{totalnum}{total number of parameters}

\item{ntime}{number of risk groups}

\item{R}{risk vector}

\item{Rls1}{First Risk sum storage}

\item{Lls1}{Second Risk sum storage}

\item{Ll}{Log-likelihood vector}

\item{debugging}{additional boolean for verbosity in testing}

\item{ties_method}{Ties method}

\item{KeepConstant}{binary vector to identify constant parameters}
}
\value{
Updates matrices in place: Log-likelihood vectors/matrix
}
\description{
Utility function to calculate Cox Log-Likelihood, basic model
\code{Calc_LogLik_Basic_Single} Basic model, Called to update log-likelihoods, Uses list of event rows, risk matrices, and repeated sums, Sums the log-likelihood contribution from each event time
}
