% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSequenceRatios.R
\name{plotSequenceRatios}
\alias{plotSequenceRatios}
\title{A plot for the sequence ratios.}
\usage{
plotSequenceRatios(
  result,
  onlyaSR = FALSE,
  plotTitle = NULL,
  labs = c("SR", "Drug Pairs"),
  colours = c("red", "blue")
)
}
\arguments{
\item{result}{Table output from summariseSequenceRatios.}

\item{onlyaSR}{If the only SR to be plotted is the adjusted SR.}

\item{plotTitle}{Title of the plot, if NULL no title will be plotted.}

\item{labs}{Axis labels for the plot.}

\item{colours}{Colours for both parts of the plot, pre- and post- time 0.}
}
\value{
A plot for the sequence ratios of index and marker cohorts.
}
\description{
It provides a ggplot of the sequence ratios of index and marker cohorts.
}
\examples{
\donttest{
library(CohortSymmetry)

cdm <- mockCohortSymmetry()
cdm <- generateSequenceCohortSet(cdm = cdm,
                                 indexTable = "cohort_1",
                                 markerTable = "cohort_2",
                                 name = "joined_cohort")
sequence_ratio <- summariseSequenceRatios(cohort = cdm$joined_cohort,
                                          minCellCount = 0)
plotSequenceRatios(result = sequence_ratio)
CDMConnector::cdmDisconnect(cdm = cdm)
}
}
