% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codesInUse.R
\name{subsetToCodesInUse}
\alias{subsetToCodesInUse}
\title{Use achilles counts to filter a codelist to keep only the codes
used in the database}
\usage{
subsetToCodesInUse(
  x,
  cdm,
  minimumCount = 0L,
  table = c("condition_occurrence", "device_exposure", "drug_exposure", "measurement",
    "observation", "procedure_occurrence", "visit_occurrence")
)
}
\arguments{
\item{x}{A codelist}

\item{cdm}{cdm_reference via CDMConnector}

\item{minimumCount}{Any codes with a frequency under this will be removed.}

\item{table}{cdm table}
}
\value{
Use achilles counts to filter codelist to only the codes used in the database
}
\description{
Use achilles counts to filter a codelist to keep only the codes
used in the database
}
\examples{
\donttest{
cdm <- mockVocabRef("database")
codes <- getCandidateCodes(cdm = cdm,
                           keywords = "arthritis",
                           domains = "Condition",
                           includeDescendants = FALSE)
x <- subsetToCodesInUse(list("cs1" = codes$concept_id,
                               "cs2" = 999),
                                cdm = cdm)

x
CDMConnector::cdmDisconnect(cdm)
}
}
