% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableAchillesCodeUse.R
\name{tableAchillesCodeUse}
\alias{tableAchillesCodeUse}
\title{Format the result of summariseAchillesCodeUse into a table.}
\usage{
tableAchillesCodeUse(
  result,
  type = "gt",
  header = c("cdm_name", "estimate"),
  conceptId = TRUE,
  standard = TRUE,
  vocabulary = TRUE,
  groupColumns = NULL,
  excludeColumns = c("result_id", "estimate_type"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised result with results of the type
"achilles_code_use".}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{header}{A vector containing which elements should go into the header
in order. Allowed are: \code{cdm_name}, \code{group}, \code{strata}, \code{additional},
\code{variable}, \code{estimate}, \code{settings}.}

\item{conceptId}{If TRUE concept ids will be displayed.}

\item{standard}{If TRUE a column indicating if the code is standard will be
displayed.}

\item{vocabulary}{If TRUE vocabulary id will be displayed.}

\item{groupColumns}{Columns to use as group labels. Allowed columns are
\code{cdm_name} and/or \code{codelist_name}.}

\item{excludeColumns}{Columns to drop from the output table.}

\item{.options}{Named list with additional formatting options.
visOmopResults::optionsVisOmopTable() shows allowed arguments and
their default values.}
}
\value{
A table with a formatted version of the summariseCohortCodeUse
result.
}
\description{
Format the result of summariseAchillesCodeUse into a table.
}
\examples{
\dontrun{
cdm <- mockVocabRef("database")
oa <- getCandidateCodes(cdm = cdm, keywords = "osteoarthritis")
result_achilles <- summariseAchillesCodeUse(list(oa = oa$concept_id), cdm = cdm)
tableAchillesCodeUse(result_achilles)
CDMConnector::cdmDisconnect(cdm)
}

}
