#' @export print.summary.hclustgeo
#' @name print.summary.hclustgeo
#' @method print summary.hclustgeo
#' @S3method print summary.hclustgeo
#' @title Print a 'summary.hclustgeo' object
#' @description This is a method for the function print for objects of the class \code{summary.hclustgeo}.
#' @param x an object of class  \code{summary.hclustgeo} generated by the function \code{summary.hclustgeo}
#' @param \dots  further arguments to be passed to or from other methods. They are ignored in this function.
#' @keywords internal


print.summary.hclustgeo <- function(x, ...){
  if (!inherits(x, "summary.hclustgeo")) 
    stop("use only with \"summary.hclustgeo\" objects")
  
  #nb.alpha<-length(x[[1]])
  
  cat("Method = summary.hclustgeo")
  cat("\n")
  cat("\n")
  
  cat("Each summary corresponding to a value of alpha is conserved in a different object")
  cat("\n")
  cat("The list of available summary is given below:")
  cat("\n")
  cat("\n")
  cat(paste("$'",names(x),"'",sep=""),sep="\n")
#   
#   
#   toprint <- matrix("",7,2)
#   colnames(toprint) <-c("name","description")
#   toprint[1,] <- c("$alpha", "parameter 'alpha' used in the hclustgeo method")
#   toprint[2,] <- c("$K.range", "parameter 'K.range' used in the method") 
#   toprint[3,] <- c("$cut", "dataframe whose colums correspond to the different typologies in 'K.range' clusters")
#   toprint[4,] <- c("$heterog", "list of heterogeneity criterions for each partitions")
#   toprint[5,] <- c("$desc", "List of descriptions of clusters for each partition generated.")
#   toprint[6,] <- c("","Partitions are described by variables of 'data.desc'")  
#   toprint[7,] <- c("$data.desc", "The data base used to describe cluster of partitions")    
#   
#   print(toprint)
  
  
}