% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simil_groups_cata.R
\name{simil_groups_cata}
\alias{simil_groups_cata}
\title{Testing the difference in perception between two predetermined groups of subjects in a CATA experiment}
\usage{
simil_groups_cata(Data, groups, one=1, two=2, nperm=50, Graph=TRUE,
  alpha= 0.05, printl=FALSE)
}
\arguments{
\item{Data}{data frame or matrix. Correspond to all the blocks of variables merged horizontally}

\item{groups}{categorical vector. The groups of each subject . The length must be the number of subjects.}

\item{one}{string. Name of the group 1 in groups vector.}

\item{two}{string. Name of the group 2 in groups vector.}

\item{nperm}{numerical. How many permutations are required? Default: 50}

\item{Graph}{logical. Should the CATATIS graph of each group be plotted? Default: TRUE}

\item{alpha}{numerical between 0 and 1. What is the threshold of the test? Default: 0.05}

\item{printl}{logical. Print the number of remaining permutations during the algorithm? Default: FALSE}
}
\value{
a list with:
    \itemize{
    \item decision: the decision of the test
    \item pval: pvalue of the test
    }
}
\description{
Test adapted to CATA data to determine whether two predetermined groups of subjects have a different perception or not. For example, men and women.
}
\examples{
\donttest{
 data(straw)
 groups=sample(1:2, 114, replace=TRUE)
 simil_groups_cata(straw, groups, one=1, two=2)
}
}
\references{
Llobell, F., Giacalone, D., Jaeger, S.R. & Qannari, E. M. (2021). CATA data: Are there differences in perception? JSM conference.\cr
Llobell, F., Giacalone, D., Jaeger, S.R. & Qannari, E. M. (2021). CATA data: Are there differences in perception? AgroStat conference.
}
\keyword{CATA}
