% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{element_sim_elscore}
\alias{element_sim_elscore}
\title{The Element-Centric Clustering Similarity for each Element}
\usage{
element_sim_elscore(
  clustering1,
  clustering2,
  alpha = 0.9,
  r_cl1 = 1,
  rescale_path_type_cl1 = "max",
  ppr_implementation_cl1 = "prpack",
  dist_rescaled_cl1 = FALSE,
  row_normalize_cl1 = TRUE,
  r_cl2 = 1,
  rescale_path_type_cl2 = "max",
  ppr_implementation_cl2 = "prpack",
  dist_rescaled_cl2 = FALSE,
  row_normalize_cl2 = TRUE
)
}
\arguments{
\item{clustering1}{The first clustering result, which can be one of:
\itemize{
\item A numeric/character/factor vector of cluster labels for each element.
\item A samples x clusters matrix/Matrix::Matrix of nonzero membership values.
\item An hclust object.
}}

\item{clustering2}{The second clustering result, which can be one of:
\itemize{
\item A numeric/character/factor vector of cluster labels for each element.
\item A samples x clusters matrix/Matrix::Matrix of nonzero membership values.
\item An hclust object.
}}

\item{alpha}{A numeric giving the personalized PageRank damping factor;
1 - alpha is the restart probability for the PPR random walk.}

\item{r_cl1}{A numeric hierarchical scaling parameter for the first clustering.}

\item{rescale_path_type_cl1}{A string; rescale the hierarchical height of
the first clustering by:
\itemize{
\item "max" : the maximum path from the root.
\item "min" : the minimum path form the root.
\item "linkage" : use the linkage distances in the clustering.
}}

\item{ppr_implementation_cl1}{Choose a implementation for personalized
page-rank calculation for the first clustering:
\itemize{
\item "prpack": use PPR algorithms in igraph.
\item "power_iteration": use power_iteration method.
}}

\item{dist_rescaled_cl1}{A logical: if TRUE, the linkage distances of the first
clustering are linearly rescaled to be in-between 0 and 1.}

\item{row_normalize_cl1}{Whether to normalize all rows in the first clustering
so they sum to one before calculating ECS. It is recommended to set this to
TRUE, which will lead to slightly different ECS values compared to clusim.}

\item{r_cl2}{A numeric hierarchical scaling parameter for the second clustering.}

\item{rescale_path_type_cl2}{A string; rescale the hierarchical height of
the second clustering by:
\itemize{
\item "max" : the maximum path from the root.
\item "min" : the minimum path form the root.
\item "linkage" : use the linkage distances in the clustering.
}}

\item{ppr_implementation_cl2}{Choose a implementation for personalized
page-rank calculation for the second clustering:
\itemize{
\item "prpack": use PPR algorithms in igraph.
\item "power_iteration": use power_iteration method.
}}

\item{dist_rescaled_cl2}{A logical: if TRUE, the linkage distances of the second
clustering are linearly rescaled to be in-between 0 and 1.}

\item{row_normalize_cl2}{Whether to normalize all rows in the second clustering
so they sum to one before calculating ECS. It is recommended to set this to
TRUE, which will lead to slightly different ECS values compared to clusim.}
}
\value{
Vector of element-centric similarity between the two clusterings for
each element.
}
\description{
Calculates the element-wise element-centric similarity between
two clustering results.
}
\examples{
km.res = kmeans(iris[,1:4], centers=8)$cluster
hc.res = hclust(dist(iris[,1:4]))
element_sim_elscore(km.res, hc.res)
}
\references{
Gates, A. J., Wood, I. B., Hetrick, W. P., & Ahn, Y. Y. (2019).
Element-centric clustering comparison unifies overlaps and hierarchy.
Scientific reports, 9(1), 1-13. https://doi.org/10.1038/s41598-019-44892-y
}
