% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_clustering_difference_facet}
\alias{plot_clustering_difference_facet}
\title{Clustering Method Stability Facet Plot}
\usage{
plot_clustering_difference_facet(
  clustering_difference_object,
  embedding,
  low_limit = 0,
  high_limit = 1,
  grid = TRUE
)
}
\arguments{
\item{clustering_difference_object}{An object returned by the
`get_clustering_difference_object` method.}

\item{embedding}{An embedding (only the first two dimensions will be used for
visualisation).}

\item{low_limit}{The lowest value of ECC that will be displayed on the embedding.}

\item{high_limit}{The highest value of ECC that will be displayed on the embedding.}

\item{grid}{Boolean value indicating whether the facet should be a grid (where each
row is associated with a resolution value and each column with a clustering method) or
a wrap.}
}
\value{
A ggplot2 object.
}
\description{
Display the distribution of the EC consistency for each
clustering method and each resolution value on a given embedding The `all`
field of the object returned by the `get_clustering_difference_object` method is used.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(c(runif(250*10), runif(250*10, min = 5, max = 7)), nrow = 500)
rownames(expr_matrix) = as.character(1:500)

pca_embedding = irlba::irlba(expr_matrix, nv = 2)
pca_embedding = pca_embedding$u \%*\% diag(pca_embedding$d)
rownames(pca_embedding) = as.character(1:500)

adj_matrix = Seurat::FindNeighbors(pca_embedding,
    k.param = 10,
    nn.method = "rann",
    verbose = FALSE,
    compute.SNN = FALSE)$nn
clust_diff_obj = get_clustering_difference(graph_adjacency_matrix = adj_matrix,
    resolution = c(0.5, 1),
    n_repetitions = 10,
    algorithm = 1:2,
    verbose = FALSE)
plot_clustering_difference_facet(clust_diff_obj,pca_embedding)
}
