% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.torus.R, R/methods.R
\name{kmeans.torus}
\alias{kmeans.torus}
\alias{predict.kmeans.torus}
\title{K-Means Clustering on Torus}
\usage{
kmeans.torus(data, centers = 10, ...)

\method{predict}{kmeans.torus}(object, newdata, ...)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}}

\item{centers}{either the number of clusters or a set of initial
cluster centers. If a number, a random set of row in x is
chosen as the initial centers.}

\item{...}{additional parameter}

\item{object}{\code{kmeans.torus} object}

\item{newdata}{\code{data} to be input}
}
\value{
returns a \code{kmeans} object, which contains
\describe{
  \item{\code{extrinsic.results}}{extrinsic k-means clustering results using ordinary kmeans algorithm.}
  \item{\code{centers}}{A matrix of cluster centers.}
  \item{\code{membership}}{A vector of integers indicating the cluster to which each point is allocated.}
  \item{\code{size}}{The number of points in each cluster.}
  \item{\code{withinss}}{Vector of within-cluster sum of squares, one component per cluster.}
  \item{\code{totss}}{The total sum of squares, based on angular distance.}
  \item{\code{betweenss}}{The between-cluster sum of squares.}
}
}
\description{
\code{kmeans.torus} implements extrinsic k-means clustering
 on toroidal space.
}
\details{
In Euclidean space, we know that the total sum of squares
  is equal to the summation of the within cluster sum of squares and
  the between cluster centers sum of squares. However, toroidal space
  does not satisfy the property; the equality does not hold. Thus,
  you need to be careful to use the sum of squares.

  Extrinsic k-means algorithm uses the ambient space for \eqn{[0, 2\pi)^d}.
  Each datum is transformed to a vector in 2d-dimensional
  Euclidean space, whose elements are sine and cosine values of the datum,
  then a usual k-means algorithm is applied to transformed data.
}
\examples{
data <- ILE[1:200, 1:2]

kmeans.torus(data, centers = 2,
             iter.max = 100, nstart = 1)
}
\references{
'S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
\seealso{
\code{\link[stats]{kmeans}}, \code{\link[ClusTorus]{ang.minus}}, \code{\link[ClusTorus]{ang.dist}}
}
