% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.torus.R
\name{hyperparam.torus}
\alias{hyperparam.torus}
\title{Selecting optimal hyperparameters for the conformal prediction set}
\usage{
hyperparam.torus(
  data,
  icp.torus.objects = NULL,
  option = c("elbow", "risk", "AIC", "BIC"),
  split.id = NULL,
  Jvec = 3:35,
  kvec = 20:100,
  alphavec = NULL,
  alpha.lim = 0.15,
  method = c("kde", "mixture", "kmeans"),
  mixturefitmethod = c("circular", "axis-aligned", "general", "Bayesian"),
  kmeansfitmethod = c("homogeneous-circular", "heterogeneous-circular", "ellipsoids",
    "general"),
  init = c("kmeans", "hierarchical"),
  eval.point = NULL,
  additional.condition = TRUE,
  kmax = 500,
  THRESHOLD = 1e-10,
  maxiter = 200,
  verbose = FALSE
)
}
\arguments{
\item{data}{n x d matrix of toroidal data on \eqn{[0, 2\pi)^d}
or \eqn{[-\pi, \pi)^d}}

\item{icp.torus.objects}{list whose elements are icp.torus objects, generated by
\code{icp.torus.score}}

\item{option}{a string one of "elbow", "risk", "AIC", or "BIC", which determines the criterion
for the model selection. "risk" is based on the negative log-likelihood, "AIC" for the
Akaike Information Criterion, and "BIC" for the Bayesian Information Criterion. "elbow" is based
on minimizing the volume of the conformal prediction set plus level. Criterion "elbow" is proposed
by Jung, et. al (2021).}

\item{split.id}{a n-dimensinal vector consisting of values 1 (estimation)
and 2(evaluation)}

\item{Jvec}{either a scalar or a vector for the number of mixture components. Default value is 3:35.}

\item{kvec}{either a scalar or a vector for the concentration parameter. Default value is 20:100.}

\item{alphavec}{either a scalar or a vector, or even \code{NULL} for the levels.
Default value is \code{NULL}. If \code{NULL}, then \code{alphavec} is
automatically generated as a sequence from 0 to \code{alpha.lim}.}

\item{alpha.lim}{a positive number lower than 1, which is the upper bound of
Default is 0.15.}

\item{method}{a string one of "all", "kde", "mixture", and "kmeans"
which determines the model for clustering. Default is "all". Moreover, if
the dimension of data space is larger than 2, then automatically
"kmeans".}

\item{mixturefitmethod}{a string one of "circular", "axis-aligned", "general",
and "Bayesian" which determines the fitting mixture method.("Bayesian" is not yet
supported) Default is "axis-aligned".}

\item{kmeansfitmethod}{character which must be "homogeneous-circular",
"heterogeneous-circular", or "general".
 If "homogeneous-circular", the radii of k-spheres are identical.
 If "heterogeneous-cricular", the radii of k-spheres may be different.
 If "ellipsoids", cluster with k-ellipsoids without optimized parameters.
 If, "general", clustering with k-ellipses. The parameters to construct
 the ellipses are optimized with generalized Lloyd algorithm, which is
 modified for toroidal space. To see the detail, see the references.}

\item{init}{determine the initial parameter of "kmeans" method,
for option "general". Must be "kmeans" or "hierarchical".
If "kmeans", the initial parameters are obtained with extrinsic kmeans
method.
If "hierarchical", the initial parameters are obtained with hierarchical
clustering method.
Default is "kmeans".}

\item{eval.point}{N x N numeric matrix on \eqn{[0, 2\pi)^2}. Default input is
\code{grid.torus}.}

\item{additional.condition}{boolean index.
If \code{TRUE}, a singular matrix will be altered to the scaled identity.}

\item{kmax}{the maximal number of kappa. If estimated kappa is
larger than \code{kmax}, then put kappa as \code{kmax}.}

\item{THRESHOLD}{number for difference between updating and
updated parameters. Default is 1e-10.}

\item{maxiter}{the maximal number of iteration. Default is 200.}

\item{verbose}{boolean index, which indicates whether display
additional details as to what the algorithm is doing or
how many loops are done. Moreover, if \code{additional.condition} is
\code{TRUE}, the warning message will be reported.}
}
\value{
returns a list object which contains \code{data.frame} objects for
  the evaluated criterion corresponding to each hyperparameter,
  selected hyperparameters based on the designated criterion, and
  an \code{icp.torus} object based the selected hyperparameters.
}
\description{
\code{hyperparam.torus} selects optimal hyperparamters for constructing the conformal prediction
  set, based on the type of postulated model and the criterion.
}
\examples{
\donttest{
data <- toydata2[, 1:2]
n <- nrow(data)
split.id <- rep(2, n)
split.id[sample(n, floor(n/2))] <- 1
Jvec <- 3:35
icp.torus.objects <- list()
for (j in Jvec){
  icp.torus.objects[[j]] <- icp.torus.score(data, split.id = split.id, method = "kmeans",
                                            kmeansfitmethod = "ge", init = "h",
                                            param = list(J = j), verbose = TRUE)
}
hyperparam.torus(data, icp.torus.objects, option = "risk")
}
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction",
  Akaike (1974), "A new look at the statistical model identification",
  Schwarz, Gideon E. (1978), "Estimating the dimension of a model"
}
