% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.alpha.R
\name{hyperparam.alpha}
\alias{hyperparam.alpha}
\title{Selecting optimal level based on the runs of the number of clusters}
\usage{
hyperparam.alpha(icp.torus, alphavec = NULL, alpha.lim = 0.15)
}
\arguments{
\item{icp.torus}{an object containing all values to compute the conformity
score, which will be constructed with \code{icp.torus.score}.}

\item{alphavec}{either a scalar or a vector, or even \code{NULL} for the levels.
Default value is \code{NULL}. If \code{NULL}, then \code{alphavec} is
automatically generated as a sequence from 0 to \code{alpha.lim}.}

\item{alpha.lim}{a positive number lower than 1, which is the upper bound of
Default is 0.15.}
}
\value{
returns a list object which contains a \code{data.frame} for
  the numbers of clusters corresponding to the levels and the optimal
  level.
}
\description{
\code{hyperparam.alpha} evaluates the numbers of clusters for various
  levels, and select the optimal level based on the runs of the cluster numbers.
}
\examples{
\donttest{
data <- toydata2[, 1:2]
n <- nrow(data)
split.id <- rep(2, n)
split.id[sample(n, floor(n/2))] <- 1
icp.torus <- icp.torus.score(data, split.id = split.id, method = "kmeans",
                             kmeansfitmethod = "ge", init = "h",
                             param = list(J = 25), verbose = TRUE)
hyperparam.alpha(icp.torus)
}
}
\seealso{
\code{\link[ClusTorus]{hyperparam.J}}, \code{\link[ClusTorus]{hyperparam.torus}}
 \code{\link[ClusTorus]{icp.torus.score}}
}
