% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.stat.desc.R
\name{add.stat}
\alias{add.stat}
\alias{add.stat.desc}
\title{Add a new statistic to an existing table}
\usage{
add.stat(tab, data, func.stat, func.stat.name, pos, ...)

\method{add.stat}{desc}(tab, data, func.stat, func.stat.name, pos = NULL,
  ...)
}
\arguments{
\item{tab}{A desc object}

\item{data}{The data frame used to create tab}

\item{func.stat}{Passed to \code{report.quanti} function}

\item{func.stat.name}{Passed to \code{report.quanti} function}

\item{pos}{Numeric used to specify the position of the new statistics}

\item{...}{Other parameters}
}
\value{
A "quanti" desc object (desc$type.desc equal to "quanti")
}
\description{
\code{add.stat.desc} 
enables to add a specific quantitative statistic into an existing table of statistics.
}
\details{
Add a specific statistic in a desc object (only works for quantitative statistics for now).
It calls the \code{\link{report.quanti}} function with the same attributes as the tab argument and 
uses the \code{\link{regroup}} function to bind the two results.
}
\examples{

# Load the data

data(datafake)

# The default statistics are given here:

tab1=report.quanti(data=datafake,y="y_numeric",x1="GROUP",total=TRUE,subjid="SUBJID")

# Define the function corresponding to the coefficient of variation for example

cv=function(y) sd(y,na.rm=TRUE)/mean(y,na.rm=TRUE)

# We use the add.stat function to add CV at the second row:

tab1.cv=add.stat(tab1,datafake,func.stat=cv,func.stat.name="Coef. Var",
pos=2)

tab1.cv

# Same with 2 explicative variables

tab=report.quanti(data=datafake,y="y_numeric",x1="GROUP",
x2="TIMEPOINT",total=TRUE,subjid="SUBJID",
	at.row="TIMEPOINT")

tab=add.stat(tab,datafake,func.stat=cv,func.stat.name="Coef. Var",
pos=2)
tab

# And on position 5, we can add for example the mode

mode=function(x)
{
  x=na.omit(x)
  ux <- unique(x)
  ux[which.max(tabulate(match(x, ux)))]
}


tab=add.stat(tab,datafake,func.stat=mode,func.stat.name="Mode",
pos=5)
tab



}
\seealso{
\code{\link{regroup}} \code{\link{report.quanti}}
}
