% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTraitList.R
\name{getTraitList}
\alias{getTraitList}
\title{Organise trait ranks in a ClimMob data}
\usage{
getTraitList(data, pattern, trait.labels = NULL, ...)
}
\arguments{
\item{data}{a data.frame with the ClimMob data}

\item{pattern}{a character with the tricot ranking pattern}

\item{trait.labels}{an optional character with clean trait labels}

\item{...}{additional arguments, not implemented yet}
}
\value{
a list with trait validation data
}
\description{
This function helps in identifying the traits 
 assessed in the tricot project and validates 
 the data returning a list with logical vectors 
 to support the transformation of tricot rankings 
 into a PlackettLuce ranking
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

require("gosset")

data("breadwheat", package = "gosset")

getTraitList(breadwheat, c("_best", "_worst"))
\dontshow{\}) # examplesIf}
}
