% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainfall.R
\name{rainfall}
\alias{rainfall}
\title{Rainfall indices}
\usage{
rainfall(object, day.one = NULL, span = NULL, index = NULL, ...)
}
\arguments{
\item{object}{a numeric vector of geographic coordinates (lonlat) or
a matrix containing the precipitation data.
When lonlat is used, the function makes a call to
\code{nasapower::get_power} to fetch and concatenate environmental data from NASA POWER
(\url{https://power.larc.nasa.gov/})}

\item{day.one}{a vector of class 'Date' for the starting date to capture the environmental data}

\item{span}{an integer or a vector with integers for the duration of the timespan to be captured}

\item{index}{optional, a character or a vector with characters for the indices to be computed. 
All indices are given by default}

\item{...}{additional arguments passed to methods}
}
\value{
A dataframe with selected indices. Options are:
\item{MLDS}{maximum length of consecutive dry days (r <  1 mm)}
\item{MLWS}{maximum length of consecutive wet days (r >= 1 mm)}
\item{R10mm}{number of heavy precipitation days (10 >= r < 20 mm)}
\item{R20mm}{number of very heavy precipitation days (r >= 20) }
\item{SDII}{simple daily intensity index (mean of wet days / total rainfall)}
\item{Rx1day}{maximum 1-day rainfall (mm)}
\item{Rx5day}{maximum 5-day rainfall (mm) }
\item{Rtotal}{total rainfall (mm) in wet days (R >= 1)}
}
\description{
Compute rainfall indices over a timespan
}
\examples{
\donttest{

library("ClimMobTools")
library("nasapower")

# random geographic locations around bbox(11, 12, 55, 58)
lonlat <- data.frame(lon = runif(10, 11, 12),
                     lat = runif(10, 55, 58))

# random planting dates around 2018-05-15 and 2018-05-20
pdates <- as.integer(runif(10, 17666, 17670))
pdates <- as.Date(pdates, origin = "1970-01-01")

# calculate rainfall for the first 50 days after planting
rainfall(lonlat,
         day.one = pdates,
         span = 50)


# include the first 15 days before planting (residual precipitation)
rainfall(lonlat,
         day.one = pdates,
         span = 50,
         days.before = 15)

}       
         
}
