% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETo.R
\name{ETo}
\alias{ETo}
\title{Evapotranspiration}
\usage{
ETo(object, day.one = NULL, span = NULL, lat = NULL, Kc = 1,
  p = NULL)
}
\arguments{
\item{object}{a numeric vector of geographic coordinates (lonlat) or
an array with two dimensions containing the temperature data;
1st dimension contains the day temperature and 2nd dimension the night temperature.
When lonlat is used, the function makes a call to
\code{nasapower::get_power} to fetch and concatenate environmental data from NASA POWER
(\url{https://power.larc.nasa.gov/})}

\item{day.one}{a vector of class 'Date' for the starting date to capture the environmental data}

\item{span}{an integer or a vector with integers for the duration of the timespan to be captured}

\item{lat}{a vector for the latitude (in Decimal degrees)}

\item{Kc}{a numeric value for the crop factor for water requirement}

\item{p}{optional, a numeric value (from 0 to 1) used if lat is not given,
representing the mean daily percentage of annual daytime hours 
for different latitudes}
}
\value{
The evapotranspiration in mm/day
}
\description{
Compute evapotranspiration using the Blaney-Criddle method
}
\examples{
\donttest{
 
library("ClimMobTools")
library("nasapower")

# random geographic locations around bbox(11, 12, 55, 58)
lonlat <- data.frame(lon = runif(10, 11, 12),
                     lat = runif(10, 55, 58))

# random planting dates around 2018-05-15 and 2018-05-20
pdates <- as.integer(runif(10, 17666, 17670))
pdates <- as.Date(pdates, origin = "1970-01-01")

# the evapotranspiration in the first 50 days after planting
ETo(lonlat,
    day.one = pdates,
    span = 50,
    lat = lonlat[["lat"]])
}

}
