% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{tci80}
\alias{tci80}
\title{Excellent tourism days TCI>80}
\usage{
tci80(data, sunshine, w, data_names = NULL, time.scale = YEAR,
  na.rm = FALSE)
}
\arguments{
\item{data}{precipitation}

\item{sunshine}{net radiation}

\item{w}{average wind}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
TCI80
}
\description{
Number of days TCI>80, standard ECA&D
Number of days TCI>80 (see TCI)
TCI = 8 Cld + 2 Cla + 4 R + 4 S + 2 W. Let TCIij be the daily value of the Tourism Climatic Index at day i of period j. Then counted is the number of days where: TCIij>=80. Where C ld is a daytime comfort index, consisting of the mean maximum air temperature Ta, max (℃) and the mean minimum relative humidity RH (%), Cla is the daily comfort index, consisting of the mean air temperature (℃) and the mean relative humidity (%), R is the precipitation (mm), S is the daily sunshine duration (h), and W is the mean wind speed (m/s).
}
\examples{
data(data_all)
tci80(data=data_all$rr, sunshine=data_all$radiation, w=data_all$wind)
}
\references{
Mieczkowski, Z. (1985). The tourism climatic index: a method of evaluating world climates for tourism. The Canadian Geographer/Le Géographe canadien, 29(3), 220-233.
}
