% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{fwi}
\alias{fwi}
\title{Canadian Fire Weather Index}
\usage{
fwi(taverage, rh, w, pr, dew_point, lat, data_names = NULL,
  time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{taverage}{medium temperature}

\item{rh}{relative humidity}

\item{w}{average wind}

\item{pr}{precipitation}

\item{dew_point}{dew_point}

\item{lat}{latitude}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
FWI
}
\description{
The Canadian Forest Fire Weather Index is an indicator of fire weather intensity and is used to represent potential fire danger. It is computed from daily values of precipitation, temperature, near-surface wind and relative humidity
dimensionless, see Van Wagner (1987).
}
\examples{
data(data_all)
fwi(taverage = data_all$tg, rh = data_all$humidity, w = data_all$wind, 
     pr = data_all$rr, dew_point=data_all$dewpoint, lat = data_all$lat)
}
\references{
Van Wagner CE. 1987. Development and structure of the Canadian forest fire weather index system. Technical Report 35, Canadian Forestry Service: Ottawa, Ontario. Bedia, J., Herrera, S., Gutiérrez, J. M., Zavala, G., Urbieta, I. R., & Moreno, J. M. (2012). Sensitivity of fire weather index to different reanalysis products in the iberian peninsula. Natural Hazards and Earth System Science, 12(3), 699-708. doi:10.5194/nhess-12-699-2012
## @importance Important application for fire prevention
}
