% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadMorphNexus.R
\name{ReadMorphNexus}
\alias{ReadMorphNexus}
\title{Reads in a morphological #NEXUS data file}
\usage{
ReadMorphNexus(File, EqualiseWeights = FALSE)
}
\arguments{
\item{File}{A file name specified by either a variable of mode character, or a double-quoted string.}

\item{EqualiseWeights}{Optional that overrides the weights specified in the file to make all characters truly equally weighted.}
}
\value{
\item{Topper}{Contains any header text or step matrices and pertains to the entire file.}
\item{Matrix_N}{One or more matrix blocks (numbered 1 to N) with associated information pertaining only to that matrix block. This includes the block name (if specificed, NA if not), the block datatype (one of "CONTINUOUS", "DNA", "NUCLEOTIDE", "PROTEIN", "RESTRICTION", "RNA", or "STANDARD"), the actual matrix (taxa as rows, names stored as rownames and characters as columns), the ordering type of each character ("ord" = ordered, "unord" = unordered), the character weights, the minimum and maximum values (used by Claddis' distance functions), and the original characters (symbols, missing, and gap values) used for writing out the data.}
}
\description{
Reads in a morphological data file in #NEXUS format.
}
\details{
Reads in a #NEXUS (Maddison et al. 1997) data file representing the distribution of characters (continuous, discrete, DNA etc.) in a set of taxa. Unlike \link{read.nexus.data} this function can handle polymorphisms (e.g., \code{(012)}).

Note that the function is generally intolerant to excursions from a standard format and it is recommended your data be formatted like the \code{morphmatrix.nex} example below. However, the function also produces informative error messages if (expected) excursions are discovered.

Previously all empty values (missing or inapplicable) were treated as NAs. But now anything coded as a "gap" now appears as an empty text string ("") in the matrix. Additionally, previously polymorphisms and uncertianties were both considered as polymorphisms with multiple states separated by an ampersand ("&"), but now polymorphisms use the ampersand ("&") and uncertainties use a slash ("/"), allowing for different treatment later and correct outputting when writing to #NEXUS format. (NB: TNT does not allow this distinction and so both polymorphisms and uncertainties will be output as polymorphisms.)
}
\examples{

# Create example matrix (NB: creates a file in the current
# working directory called "morphmatrix.nex"):
cat("#NEXUS\\n\\nBEGIN DATA;\\n\\tDIMENSIONS  NTAX=5 NCHAR=5;\\n\\t
FORMAT SYMBOLS= \\" 0 1 2\\" MISSING=? GAP=- ;\\nMATRIX\\n\\n
Taxon_1  010?0\\nTaxon_2  021?0\\nTaxon_3  02111\\nTaxon_4  011-1
\\nTaxon_5  001-1\\n;\\nEND;\\n\\nBEGIN ASSUMPTIONS;\\n\\t
OPTIONS  DEFTYPE=unord PolyTcount=MINSTEPS ;\\n\\t
TYPESET * UNTITLED  = unord: 1 3-5, ord: 2;\\n\\t
WTSET * UNTITLED  = 1: 2, 2: 1 3-5;\\nEND;", file = "morphmatrix.nex")

# Read in example matrix:
morph.matrix <- ReadMorphNexus("morphmatrix.nex")

# View example matrix in R:
morph.matrix

# Remove the generated data set:
file.remove("morphmatrix.nex")

}
\references{
Maddison, D. R., Swofford, D. L. and Maddison, W. P., 1997. NEXUS: an extensible file format for systematic information. Systematic Biology, 46, 590-621.
}
\seealso{
\link{read.nexus.data}
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
