% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EdgeMatch.R
\name{EdgeMatch}
\alias{EdgeMatch}
\title{Edge matching function}
\usage{
EdgeMatch(original.tree, pruned.tree)
}
\arguments{
\item{original.tree}{A tree in phylo format.}

\item{pruned.tree}{A tree in phylo format that represents a pruned version of \code{original.tree}.}
}
\value{
\item{matching.edges}{A list of the matching edges.}
\item{matching.nodes}{A matrix of matching node numbers.}
\item{removed.edges}{A vector of the removed edges.}
}
\description{
Given two trees where one is a pruned version of the other gives matching edges and nodes of pruned tree to original tree.
}
\details{
Finds matching edge(s) and node(s) for a pruned tree in the original tree from which it was created. This is intended as an internal function, but may be of use to someone.
}
\examples{

# Create a random 10-taxon tree:
original.tree <- rtree(10)

# Remove three leaves:
pruned.tree <- drop.tip(original.tree, c("t1", "t3", "t8"))

# Find matching edges:
X <- EdgeMatch(original.tree, pruned.tree)

# Show matching edges:
X$matching.edges

# Show removed edges:
X$removed.edges

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
