% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcu_model.R
\name{pcu_model}
\alias{pcu_model}
\title{Positive Chill Units - PCU}
\usage{
pcu_model(x, total = TRUE)
}
\arguments{
\item{x}{Vector containing temperature values (Celsius-degree).}

\item{total}{TRUE Shows the total value of accumulation, FALSE shows the value of chill-unit for each temperature (TRUE is default).}
}
\value{
The function returns values the chill-units for each temperature of vector.
}
\description{
Quantifies the chill accumulation by means of converting temperatures to positive chill-units - Modified Utah Model.
}
\details{
The PCU Model is the modified Utah Model. When the temperature is above 15.9°C, the chill-unit is 0. This modification was made because when the Utah model is applied in warm conditions, accumulation becomes negative.
}
\examples{

x <- rnorm(500, 15, 4)
pcu_model(x)
pcu_model(x, FALSE)

}
\references{
Richardson, E. A. et al. 1974. "A Model for Estimating the Completation of Rest for 'Redhaven' and 'Elberta' Peach Trees". Research Reports & Notes. 

Linsley-Noakes, G. C. et al. 1995. "Estimating daily positive Utah Chill units using daily minimum and maximum temperatures".
}
