% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pml_model.r
\name{listCovariateEffectNames}
\alias{listCovariateEffectNames}
\alias{listCovariateEffectNames,NlmePmlModel-method}
\title{Lists covariate effect names in the model}
\usage{
listCovariateEffectNames(.Object)

\S4method{listCovariateEffectNames}{NlmePmlModel}(.Object)
}
\arguments{
\item{.Object}{PK/PD model}
}
\value{
A vector of character strings containing the names
of the covariate effects in the model.
}
\description{
This function lists the names of covariate effects in a provided
pharmacokinetic/pharmacodynamic (PK/PD) model.
}
\examples{
\donttest{
model <- pkmodel(
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  workingDir = tempdir()
)
model <- addCovariate(model,
  covariate = "Gender",
  type = "Categorical",
  effect = c("V2", "Cl2"),
  levels = c(0, 1),
  labels = c("Female", "Male")
)
listCovariateEffectNames(model)
}
}
