% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_mmdl.R
\name{extract_mmdl}
\alias{extract_mmdl}
\title{extract files used for powershell script}
\usage{
extract_mmdl(
  mmdlfile,
  directoryToExtract,
  dataFileName = "data1.txt",
  mdlOutput = "test.mdl",
  cols1Output = "cols1.txt",
  nlmeargsOutput = "nlmeargs.txt"
)
}
\arguments{
\item{mmdlfile}{The metamodel file path; relative paths are acceptable.}

\item{directoryToExtract}{The directory where the files should be stored
If \code{missing}, current working directory is used.}

\item{dataFileName}{the name of the data file
If \code{missing}, the default file name 'data1.txt' is used to prepare
\code{nlmeargsOutput} file}

\item{mdlOutput}{the name of the file to output PML code
If \code{missing}, the default file name 'test.mdl' is used.}

\item{cols1Output}{the name of the file to output columns defintion
If \code{missing}, the default file name 'cols1.txt' is used.}

\item{nlmeargsOutput}{the name of the file to output engine parameters
If \code{missing}, the default file name 'nlmeargs.txt' is used.}
}
\value{
The results of \code{\link[=create_model_from_metamodel]{create_model_from_metamodel()}} run are returned.
}
\description{
Use for extraction of the NLME files from mmdl file.
}
\details{
\code{mdlOutput}, \code{dataFileName}, \code{cols1Output}, \code{nlmeargsOutput} files are
extracted into the folders, the names of the folders are built as
\verb{\{Number of estimation/simulation block in metamodel\}}-
\verb{\{'est' for estimation block/'sim' for simulation block\}}. All estimation blocks are going first
irrespective of the simulation blocks presence, all simulation blocks
are going next.
}
\examples{
\donttest{
# path to metamodel should be specified, all other arguments set to default
extract_mmdl("metamodel.mmdl")
}

}
\seealso{
\code{\link[=create_model_from_metamodel]{create_model_from_metamodel()}}
}
\keyword{internal}
