% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cep_lda.R
\name{cep.lda}
\alias{cep.lda}
\title{Discriminant Analysis of Time Series in the Presence of Within-Group Spectral Variability}
\usage{
cep.lda(y,x,xNew,L,mcep,nw,k,cv,tol)
}
\arguments{
\item{y}{n-vector indicating group membership of training time series.}

\item{x}{\emph{N} by \emph{n} matrix containing \emph{n} training time series each with length \emph{N}.}

\item{xNew}{\emph{N} by \emph{nNew} matrix, containing nNew time series whose memberships are predicted.}

\item{L}{Number of cepstral coefficients used in the lda.  If FALSE, cross-validation is used for the data driven selection of L.  Default is FALSE.}

\item{mcep}{Maximum number of cepstral coefficients considerd. Default is set to 10.}

\item{nw}{Width of tapers used in multitaper spectral estimation. Default is set to 4.}

\item{k}{Number of tapers used in multitaper spectral estimation. Default is set to 7.}

\item{cv}{If TRUE, returns results (classes and posterior probabilities) for leave-one-out cross-validation. Note that, if the prior is estimated, the proportions in the whole dataset are used. As with the standard lda function, 
if used, prediction on a test data set cannot be done and weight functions are not produced (simular to the predict.lda). Default is FALSE.}

\item{tol}{Tolerance to decide if a matrix is singular; it will reject variables and linear combinations of unit-variance variables whose variance is less than \eqn{tol^2}.}
}
\value{
List with 5 elements
\item{C.lda}{lda output on the cepstral scale. Similar to output of \code{lda(MASS)} function.}
\item{cep.data}{Data frame containing cepstral coefficients and group information from training data.}
\item{Lopt}{Number of cepstral coefficients used.}
\item{lspec}{Estimated log-spectral weight functions.}
\item{predict}{Results of classification.  If external data xNew is supplied, these data are classified.  If not, biased classification of the training data x is returned.  For unbiased leave-out-one
     cross-validated classification of training data, use cv=TRUE.}
}
\description{
The main program.
}
\examples{
## Simulate training data
nj = 50  #number of series in training data
N = 500  #length of time series
traindata1 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.01,.7),r.phi2=c(-.12,-.06),r.sig2=c(.3,3))
traindata2 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.5,1.2),r.phi2=c(-.36,-.25),r.sig2=c(.3,3))
traindata3 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.9,1.5),r.phi2=c(-.56,-.75),r.sig2=c(.3,3))
train <- cbind(traindata1$X,traindata2$X,traindata3$X)
y <- c(rep(1,nj),rep(2,nj),rep(3,nj))

## Fit the discriminant analysis
fit <- cep.lda(y,train)
fit  #displays group means and cepstral weight functions

## Discriminant plot
plot(fit)

## Plot log-spectral weights
par(mfrow=c(1,2))
plot(fit$lspec$frq, fit$lspec$dsc[,1],type='l',xlab="frequency", ylab="log-spectral weights")
plot(fit$lspec$frq, fit$lspec$dsc[,2],type='l',xlab="frequency", ylab="log-spectral weights")

## Bias classification of training data
mean(fit$predict$class == y) #classifictaion rate
table(y,fit$predict$class)

## Fit the discriminant analysis while classifing training data via cross-validation
fit.cv <- cep.lda(y,train, cv=TRUE)
mean(fit.cv$predict$class == y) #classifictaion rate
table(y,fit.cv$predict$class)

## Simulate test data
testdata1 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.01,.7),r.phi2=c(-.12,-.06),r.sig2=c(.3,3))
testdata2 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.5,1.2),r.phi2=c(-.36,-.25),r.sig2=c(.3,3))
testdata3 <- r.cond.ar2(N=N,nj=nj,r.phi1=c(.9,1.5),r.phi2=c(-.56,-.75),r.sig2=c(.3,3))
test <- cbind(testdata1$X,testdata2$X,testdata3$X)
yTest <- c(rep(1,nj),rep(2,nj),rep(3,nj))

## Fit discriminant analysis and classify new data
fit.pre <- cep.lda(y,train,test)
mean(fit.pre$predict$class == y)
table(yTest,fit.pre$predict$class)
}
\author{
Zeda Li \email{<zeda.li@temple.edu>}; Robert Krafty \email{<rkrafty@pitt.edu>}
}
\references{
Krafty, RT (2016) Discriminant Analysis of Time Series in the Presence of Within-Group Spectral Variability.  \emph{Journal of Time Series Analysis}
}
\seealso{
\code{\link{predict.ceplda}}, \code{\link{plot.ceplda}}, \code{\link{print.ceplda}}, \code{\link{Lopt.get}}
}

