% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absolute_corr_fun.R
\name{absolute_corr_fun}
\alias{absolute_corr_fun}
\title{Check Covariate Balance Using Absolute Approach}
\usage{
absolute_corr_fun(w, c)
}
\arguments{
\item{w}{A vector of observed continuous exposure variable.}

\item{c}{A data table of observed covariates variable.}
}
\value{
The function returns a list including:
\itemize{
\item \code{absolute_corr}: the absolute correlations for each pre-exposure
covariates;
\item \code{mean_absolute_corr}: the average absolute correlations for all
pre-exposure covariates.
}
}
\description{
Checks covariate balance based on absolute correlations for given data sets.
}
\examples{
set.seed(291)
n <- 100
mydata <- generate_syn_data(sample_size=100)
year <- sample(x=c("2001","2002","2003","2004","2005"),size = n, replace = TRUE)
region <- sample(x=c("North", "South", "East", "West"),size = n, replace = TRUE)
mydata$year <- as.factor(year)
mydata$region <- as.factor(region)
mydata$cf5 <- as.factor(mydata$cf5)
data.table::setDT(mydata)
cor_val <- absolute_corr_fun(mydata[,2], mydata[, 3:length(mydata)])
print(cor_val$mean_absolute_corr)

}
