% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CausCor.R
\name{filter_40}
\alias{filter_40}
\title{Make list of A-B pair causal correlations - 40\% Filtering version}
\usage{
filter_40(
  a_mat,
  b_mat,
  a_category,
  b_category,
  min_cor,
  min_r2,
  min_sample = ceiling((ncol(a_mat) - 1) * 0.4),
  max_sample = ncol(a_mat) - 1 - min_sample
)
}
\arguments{
\item{a_mat}{Matrix of measurements of A for each sample.}

\item{b_mat}{Matrix of measurements of B for each sample.}

\item{a_category}{Category name of A.}

\item{b_category}{Category name of B.}

\item{min_cor}{Minimum spearman correlation coefficient.}

\item{min_r2}{Minimum R2.}

\item{min_sample}{Minimum number of samples. The default is 40\% of the
total samples.}

\item{max_sample}{Maximum number of samples. The default is 60\% of the
total samples.}
}
\description{
Make list of A-B pair causal correlations - 40\% Filtering version
}
