% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permTestCor.R, R/permTestCor.default.R,
%   R/permTestCor.formula.R
\name{permTestCor}
\alias{permTestCor}
\alias{permTestCor.default}
\alias{permTestCor.formula}
\title{Permutation test for the correlation of two variables.}
\usage{
permTestCor(x, ...)

\method{permTestCor}{default}(
  x,
  y,
  B = 999,
  alternative = "two.sided",
  plot.hist = TRUE,
  legend.loc = "topright",
  plot.qq = FALSE,
  x.name = deparse(substitute(x)),
  y.name = deparse(substitute(y)),
  ...
)

\method{permTestCor}{formula}(formula, data, subset, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{y}{a numeric vector.}

\item{B}{the number of resamples to draw (positive integer greater than 2).}

\item{alternative}{alternative hypothesis. Options are \code{"two.sided"},
\code{"less"} or \code{"greater"}.}

\item{plot.hist}{a logical value. If \code{TRUE}, plot the distribution of
the correlations obtained from each resample.}

\item{legend.loc}{location of the legend on the histogram. Options are
\code{"topright"}, \code{"topleft"}, \code{"bottomleft"} and
\code{"bottomright"}.}

\item{plot.qq}{a logical value. If \code{TRUE}, plot the normal
quantile-quantile plot of the correlations obtained from each resample.}

\item{x.name}{Label for variable x}

\item{y.name}{Label for variable y}

\item{formula}{a formula \code{y ~ x} where \code{x, y} are numeric vectors.}

\item{data}{a data frame that contains the variables given in the formula.}

\item{subset}{an optional expression indicating what observations to use.}
}
\value{
Returns invisibly a vector of the correlations obtained by the
randomization.
}
\description{
Hypothesis test for a correlation of two variables. The null hypothesis is
that the population correlation is 0.
}
\details{
Perform a permutation test to test \eqn{latex}{H_0: \rho = 0}, where
\eqn{latex}{\rho}is the population correlation. The rows of the second
variable are permuted and the correlation is re-computed.

The mean and standard error of the permutation distribution is printed as
well as a P-value.

Observations with missing values are removed.
}
\section{Methods (by class)}{
\itemize{
\item \code{permTestCor(default)}: Permutation test for the correlation of two variables.

\item \code{permTestCor(formula)}: Permutation test for the correlation of two variables.

}}
\examples{

plot(states03$HSGrad, states03$TeenBirths)
cor(states03$HSGrad, states03$TeenBirths)

permTestCor(states03$HSGrad, states03$TeenBirths)
permTestCor(TeenBirths ~ HSGrad, data = states03)

}
\references{
Tim Hesterberg's website:
\url{https://www.timhesterberg.net/bootstrap-and-resampling}
}
\author{
Laura Chihara
}
\keyword{correlation}
\keyword{permutation}
\keyword{randomization}
\keyword{resampling}
\keyword{test}
