% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calSSB.R
\name{CalSSBobj}
\alias{CalSSBobj}
\title{Create or modify a CalSSB object}
\usage{
CalSSBobj(x = NULL, y = NULL, w = NULL, wGross = NULL, resids = NULL,
  resids2 = NULL, leverages = NULL, leverages2 = NULL,
  samplingWeights = NULL, extra = NULL, id = NULL, wave = NULL)
}
\arguments{
\item{x}{NULL or an  existing calSSB object}

\item{y}{y}

\item{w}{w}

\item{wGross}{wGross}

\item{resids}{resids}

\item{resids2}{resids2}

\item{leverages}{leverages}

\item{leverages2}{leverages2}

\item{samplingWeights}{samplingWeights}

\item{extra}{extra}

\item{id}{id}

\item{wave}{wave}
}
\value{
A CalSSB object. That is, an object of the type retuned by \code{\link{CalibrateSSB}}.
}
\description{
The elements of the CalSSB object are taken directly from the input parameters.
}
\examples{
#' # Generates data - two years
z <- AkuData(3000)  # 3000 in each quarter
zPop <- AkuData(10000)[, 1:7]

# Create a CalSSB object by CalibrateSSB
b <- CalibrateSSB(z, calmodel = "~ sex*age", partition = c("year", "q"), popData = zPop, 
                  y = c("unemployed", "workforce"))

# Modify the CalSSB object
a <- CalSSBobj(b, w = 10*b$w, wave = CrossStrata(z[, c("year", "q")]), id = z$id)

# Use the CalSSB object as input ...
PanelEstimation(WideFromCalibrate(a), "unemployed", linComb = PeriodDiff(8, 4))

# Create CalSSB object without x as input
CalSSBobj(y = b$y, w = 10*b$w, resids = b$resids, wave = CrossStrata(z[, c("year", "q")]), 
          id = z$id)

}
\seealso{
\code{\link{CalibrateSSB}}, \code{\link{WideFromCalibrate}},  \code{\link{PanelEstimation}}.
}
