% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CaliCo-package.R
\docType{package}
\name{CaliCo}
\alias{CaliCo}
\alias{CaliCo-package}
\title{Bayesian calibration for computational codes}
\description{
The CaliCo package provides five main functions:
\code{\link{model}}, \code{\link{prior}}, \code{\link{calibrate}}, \code{\link{forecast}} and
 \code{\link{sequentialDesign}}.
}
\details{
Package: CaliCo

Type:    Package

Version: 0.1.1

Date:    2018-04-13

License: GPL-2 | GPL-3
}
\examples{
# Introduction to CaliCo
\dontrun{vignette("CaliCo-introduction")}
}
\references{
Bachoc, F., Blois, G., Garnier, J., and Martinez, J.-M. (2014). Calibration and improved prediction of computer models
by universal kriging. Computational Statistics and Data Analysis, pages 81–97

Bayarri, M., Berger, J., Sacks, P. R., Cafeo, J. A., Cavendish, J., Lin, C. H., and Tu, J. (2007 b). A framework for
validation of computer models. Technometrics.

Carmassi, M., Barbillon ,P., Chiodetti, M., Keller, M., Parent, E. (2018). Bayesian calibration of a numerical code for prediction,
arXiv preprint arXiv:1801.01810.

Cox, D., Park, J. S., and Singer, C. (2001). A statistical method for tuning a computer code to a data base. Computational
Statistics and Data Analysis.

Damblin, G. (2015). Contributions statistiques au calage et à la validation des codes de calculs. PhD thesis, University
Paris-Saclay

Hastings, W. K. (1970). Mont carlo sampling methods using markov chains and their applications. Biometrika.

Higdon, D., Kennedy, M. C., Cavendish, J., Cafeo, J., and Ryne, R. (2004). Combining field data and computer
simulations for calibration and prediction. SIAM Journal on Scientific Computing.

Kennedy, M. C. and O’Hagan, A. (2001). Bayesian calibration of computer models. Journal of the Royal Statistical
Society, serie B, Methodological.

Kennedy, M. C. and O’Hagan, A. (2001b). Supplementary details on bayesian calibration of computer models. Journal
of the Royal Statistical Society, serie B, Methodological.

Liu, F., Bayarri, S., and Berger, J. (2009). Modularization in bayesian analysis, with emphasis on analysis of computer
models. Bayesian Analysis, pages 119–150.

Robert, C. (1996). Méthodes de monte carlo par chaines de markov. economica.

Roustant, O., Ginsbourger, D., and Devills, Y. (2012). Dicekriging, diceoptim : Two r packages for the analysis of
computer experiments by kriging-based metamodeling and optimization. Journal of Statistical Software.

Sacks, J., Welch, W. J., and Toby J. Mitchell, H. P. W. (1989). Design and analysis of computer experiments. Statistical
science, pages 409–423.

Santner, T., Williams, B., and Notz, W. (2003). The Design and Analysis of Computer Experiments. Springer-Verlab.
}
\author{
Mathieu Carmassi

Maintainer: \email{mathieu.carmassi@gmail.com}
}
