% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{kl_div}
\alias{kl_div}
\title{Kullback-Leibler Divergence}
\usage{
kl_div(x, y)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}

\item{y}{An \linkS4class{Expression}, vector, or matrix.}
}
\value{
An \linkS4class{Expression} representing the KL-divergence of the input.
}
\description{
The elementwise Kullback-Leibler divergence, \eqn{x\log(x/y) - x + y}.
}
\examples{
n <- 5
alpha <- seq(10, n-1+10)/n
beta <- seq(10, n-1+10)/n
P_tot <- 0.5
W_tot <- 1.0

P <- Variable(n)
W <- Variable(n)
R <- kl_div(alpha*W, alpha*(W + beta*P)) - alpha*beta*P
obj <- sum(R)
constr <- list(P >= 0, W >= 0, sum(P) == P_tot, sum(W) == W_tot)
prob <- Problem(Minimize(obj), constr)
result <- solve(prob)

result$value
result$getValue(P)
result$getValue(W)
}
