% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{logistic}
\alias{logistic}
\title{Logistic Function}
\usage{
logistic(x)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}
}
\value{
An \linkS4class{Expression} representing the logistic function evaluated at the input.
}
\description{
The elementwise logistic function, \eqn{\log(1 + e^x)}.
This is a special case of log(sum(exp)) that evaluates to a vector rather than to a scalar, which is useful for logistic regression.
}
\examples{
set.seed(92)
n <- 20
m <- 1000
sigma <- 45

beta_true <- stats::rnorm(n)
idxs <- sample(n, size = 0.8*n, replace = FALSE)
beta_true[idxs] <- 0
X <- matrix(stats::rnorm(m*n, 0, 5), nrow = m, ncol = n)
y <- sign(X \%*\% beta_true + stats::rnorm(m, 0, sigma))

beta <- Variable(n)
X_sign <- apply(X, 2, function(x) { ifelse(y <= 0, -1, 1) * x })
obj <- -sum(logistic(-X[y <= 0,] \%*\% beta)) - sum(logistic(X[y == 1,] \%*\% beta))
prob <- Problem(Maximize(obj))
result <- solve(prob)

log_odds <- result$getValue(X \%*\% beta)
beta_res <- result$getValue(beta)
y_probs <- 1/(1 + exp(-X \%*\% beta_res))
log(y_probs/(1 - y_probs))
}
