% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{sum_largest}
\alias{sum_largest}
\title{Sum of Largest Values}
\usage{
sum_largest(x, k)
}
\arguments{
\item{x}{An \linkS4class{Expression}, vector, or matrix.}

\item{k}{The number of largest values to sum over.}
}
\value{
An \linkS4class{Expression} representing the sum of the largest \code{k} values of the input.
}
\description{
The sum of the largest \eqn{k} values of a vector or matrix.
}
\examples{
set.seed(122)
m <- 300
n <- 9
X <- matrix(stats::rnorm(m*n), nrow = m, ncol = n)
X <- cbind(rep(1,m), X)
b <- c(0, 0.8, 0, 1, 0.2, 0, 0.4, 1, 0, 0.7)
y <- X \%*\% b + stats::rnorm(m)

beta <- Variable(n+1)
obj <- sum_largest((y - X \%*\% beta)^2, 100)
prob <- Problem(Minimize(obj))
result <- solve(prob)
result$getValue(beta)
}
