% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/expressions.R, R/constraints.R
\docType{methods}
\name{\%>>\%}
\alias{\%>>\%}
\alias{\%<<\%}
\alias{\%>>\%,Expression,Expression-method}
\alias{\%>>\%,Expression,ConstVal-method}
\alias{\%>>\%,ConstVal,Expression-method}
\alias{\%<<\%,Expression,Expression-method}
\alias{\%<<\%,Expression,ConstVal-method}
\alias{\%<<\%,ConstVal,Expression-method}
\alias{PSDConstraint-class}
\alias{.PSDConstraint}
\alias{PSDConstraint}
\alias{name,PSDConstraint-method}
\alias{is_dcp,PSDConstraint-method}
\alias{is_dgp,PSDConstraint-method}
\alias{residual,PSDConstraint-method}
\alias{canonicalize,PSDConstraint-method}
\title{The PSDConstraint class.}
\usage{
e1 \%>>\% e2

e1 \%<<\% e2

\S4method{\%>>\%}{Expression,Expression}(e1, e2)

\S4method{\%>>\%}{Expression,ConstVal}(e1, e2)

\S4method{\%>>\%}{ConstVal,Expression}(e1, e2)

\S4method{\%<<\%}{Expression,Expression}(e1, e2)

\S4method{\%<<\%}{Expression,ConstVal}(e1, e2)

\S4method{\%<<\%}{ConstVal,Expression}(e1, e2)

PSDConstraint(expr, id = NA_integer_)

\S4method{name}{PSDConstraint}(x)

\S4method{is_dcp}{PSDConstraint}(object)

\S4method{is_dgp}{PSDConstraint}(object)

\S4method{residual}{PSDConstraint}(object)

\S4method{canonicalize}{PSDConstraint}(object)
}
\arguments{
\item{e1, e2}{The \linkS4class{Expression} objects or numeric constants to compare.}

\item{expr}{An \linkS4class{Expression}, numeric element, vector, or matrix representing \eqn{X}.}

\item{id}{(Optional) A numeric value representing the constraint ID.}

\item{x, object}{A \linkS4class{PSDConstraint} object.}
}
\description{
This class represents the positive semidefinite constraint, \eqn{\frac{1}{2}(X + X^T) \succeq 0}, i.e. \eqn{z^T(X + X^T)z \geq 0} for all \eqn{z}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{name(PSDConstraint)}: The string representation of the constraint.

\item \code{is_dcp(PSDConstraint)}: The constraint is DCP if the left-hand and right-hand expressions are affine.

\item \code{is_dgp(PSDConstraint)}: Is the constraint DGP?

\item \code{residual(PSDConstraint)}: A \linkS4class{Expression} representing the residual of the constraint.

\item \code{canonicalize(PSDConstraint)}: The graph implementation of the object. Marks the top level constraint as the \code{dual_holder} so the dual value will be saved to the \linkS4class{PSDConstraint}.

}}
\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression}, numeric element, vector, or matrix representing \eqn{X}.}
}}

