% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{cumsum_axis}
\alias{cumsum_axis}
\alias{cumsum}
\alias{cumsum,Expression-method}
\title{Cumulative Sum}
\usage{
cumsum_axis(expr, axis = 2)

\S4method{cumsum}{Expression}(x)
}
\arguments{
\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, and \code{2} indicates columns. The default is \code{2}.}

\item{x, expr}{An \linkS4class{Expression}, vector, or matrix.}
}
\description{
The cumulative sum, \eqn{\sum_{i=1}^k x_i} for \eqn{k=1,\ldots,n}.
When calling \code{cumsum}, matrices are automatically flattened into column-major order before the sum is taken.
}
\examples{
val <- cbind(c(1,2), c(3,4))
value(cumsum(Constant(val)))
value(cumsum_axis(Constant(val)))

x <- Variable(2,2)
prob <- Problem(Minimize(cumsum(x)[4]), list(x == val))
result <- solve(prob)
result$value
result$getValue(cumsum(x))
}
